# Lectura de la base de datos
datos<-read.csv2("malezas.csv",row.names=1)
library(vegan)

#-------------------
# OPCIONES DE ESCALAMIENTO CON DISTANCIA JACCARD

str(datos)
# nMDS con la funcin "metaMDS"
datos.mds2 <- metaMDS(datos[,4:125],trace = FALSE,distance = "bray")
datos.mds2


#-------------------
# 1)
# Graficas del nMDS con todas las sp de malezas
plot(datos.mds2, type = "t",display = c("sites", "species"),
     ylab="Dim 2", xlab="Dim 1", ex=0.6,shrink = FALSE,
     xlim=c(-1.7,1))
abline(h=0,lty=2)
abline(v=0,lty=2)

# Incluir rotulos de sitios o especies adicionales
identify(fig, what = "sites", cex = 0.7, col = "blue")
identify(fig, what = "species", cex = 0.7, col = "red") 


write.csv2(datos.mds2$species,"especies1.csv")


#-------------------
# 2)
# Graficas del nMDS con correccin en solapamiento de sp
http://r.789695.n4.nabble.com/label-plotting-on-nmds-diagram-td839832.html

fig=plot(datos.mds2, type = "n",display = c("sites", "species"),
     ylab="Dim 2", xlab="Dim 1", ex=0.6,shrink = FALSE)
abline(h=0,lty=2)
abline(v=0,lty=2)
text(datos.mds2, display="sites", labels = as.character(datos$Control), 
     cex=0.6, col="blue", lwd=1.5, pos=3)

# Las especies q muestra son promedios ponderados
points(datos.mds2, labels = as.character(datos$Mtodo.control), 
       display = "sites", cex = 0.6, col = "blue", lwd=1.5)
ordi=orditorp(datos.mds2, display = "species", shrink = FALSE, col = "red", type="n") 



#-------------------
# 3)
# Graficas del nMDS con correccin en solapamiento de sp
http://r.789695.n4.nabble.com/label-plotting-on-nmds-diagram-td839832.html

fig=plot(datos.mds2, type = "n",display = c("sites", "species"),
         ylab="Dim 2", xlab="Dim 1", ex=0.6,shrink = FALSE)
abline(h=0,lty=2)
abline(v=0,lty=2)

# Las especies q muestra son promedios ponderados
points(datos.mds2, display = "sites", cex = 0.6, col = "blue")
text(datos.mds2, display="sites", labels = as.character(datos$Control), 
     cex=0.6, col="blue", lwd=1.5, pos=3)
ordi=orditorp(datos.mds2, display = "species", shrink = FALSE, 
              col = "red", type="n") 

ordiellipse(datos.mds2, datos$Regin, scaling = "symmetric", conf=0.95, kind = "se",
            lwd=2)
ordibar(datos.mds2, datos$Regin, kind="se", conf=0.95, lwd=1,cex.lab=0.8, 
        label=TRUE)



#--------------------
# Figura tipo Araa en ggplot2 - como Ordispider de vegal
https://stackoverflow.com/questions/47516448/how-to-get-ordispider-like-clusters-in-ggplot-with-nmds

library(ggplot2)

#puntajes del NMDS
scrs <- scores(datos.mds2, display = 'sites')

# Managementcomo una variable al marco de datos de las puntuaciones
scrs <- cbind(as.data.frame(scrs), Regin = datos$Regin)

# centroides de grupo, que son la coordenada media en cada eje, agrupando:
cent <- aggregate(cbind(NMDS1, NMDS2) ~ Regin, data = scrs, FUN = mean)

# Dibujar araa
segs <- merge(scrs, setNames(cent, c('Regin','oNMDS1','oNMDS2')),
              by = 'Regin', sort = FALSE)

# Figura
ggplot(scrs, aes(x = NMDS1, y = NMDS2, colour = Regin)) +
  geom_segment(data = segs, 
               mapping = aes(xend = oNMDS1, yend = oNMDS2)) + # spiders
  geom_point(data = cent, size = 5) +                         # centroids
  geom_point()                      +                         # sample scores
  coord_fixed()                                               # same axis scaling



#---------------
# PCA - Factoextra
library(factoextra)
datos.hel <- decostand(datos[,4:125], "hellinger")
datos.hel
#*** Solo 29% de varianza en los dos primeros componentes.

res.pca <- prcomp(datos.hel,  scale = TRUE)
summary(res.pca)

# Graph of individuals
# +++++++++++++++++++++

# Default plot
# Use repel = TRUE to avoid overplotting (slow if many points)
fviz_pca_ind(res.pca, col.ind = "#00AFBB",
             repel = TRUE)


# 1. Control automatically the color of individuals 
# using the "cos2" or the contributions "contrib"
# cos2 = the quality of the individuals on the factor map
# 2. To keep only point or text use geom = "point" or geom = "text".
# 3. Change themes using ggtheme: http://www.sthda.com/english/wiki/ggplot2-themes

fviz_pca_ind(res.pca, col.ind="cos2", geom = "point",
             gradient.cols = c("white", "#2E9FDF", "#FC4E07" ))

# Color individuals by groups, add concentration ellipses
# Change group colors using RColorBrewer color palettes
# Read more: http://www.sthda.com/english/wiki/ggplot2-colors
# Remove labels: label = "none".
fviz_pca_ind(res.pca, label="none", habillage=datos$Regin,
             addEllipses=TRUE, ellipse.level=0.95, palette = "Dark2")


# Change group colors manually
# Read more: http://www.sthda.com/english/wiki/ggplot2-colors
fviz_pca_ind(res.pca, label="none", habillage=iris$Species,
             addEllipses=TRUE, ellipse.level=0.95,
             palette = c("#999999", "#E69F00", "#56B4E9"))

# Select and visualize some individuals (ind) with select.ind argument.
# - ind with cos2 >= 0.96: select.ind = list(cos2 = 0.96)
# - Top 20 ind according to the cos2: select.ind = list(cos2 = 20)
# - Top 20 contributing individuals: select.ind = list(contrib = 20)
# - Select ind by names: select.ind = list(name = c("23", "42", "119") )

# Example: Select the top 40 according to the cos2
fviz_pca_ind(res.pca, select.ind = list(cos2 = 40))


# Graph of variables
# ++++++++++++++++++++++++++++

# Default plot
fviz_pca_var(res.pca, col.var = "steelblue")

# Control variable colors using their contributions
fviz_pca_var(res.pca, col.var = "contrib", 
             gradient.cols = c("white", "blue", "red"),
             ggtheme = theme_minimal())


# Biplot of individuals and variables
# ++++++++++++++++++++++++++
# Keep only the labels for variables
# Change the color by groups, add ellipses
fviz_pca_biplot(res.pca, label = "var", habillage=datos$Regin,
                addEllipses=TRUE, ellipse.level=0.95,
                ggtheme = theme_minimal())





#-------------
# Con paquete ggord
https://www.r-bloggers.com/reinventing-the-wheel-for-ordination-biplots-with-ggplot2/

library(devtools)
install_github('fawda123/ggord')
library(ggord)
ggord(datos.mds2, datos$Regin, cex.lab=0.6, veccol = "blue",
      txt = 3, coord_fix = TRUE)





#------------------
# nMDS con Ordihull
plot(datos.mds2, type = "n",display = c("species"),
     ylab="Dimensin 2", xlab="Dimensin 1",
     cex=0.7,cex.lab=1.3)
abline(h=0,lty=2)
abline(v=0,lty=2)

text(datos.mds2, display="sites", labels = as.character(datos$Control), 
     cex=0.6, col="blue", lwd=1.5, pos=3)
orditorp(datos.mds2, display = "species", shrink = FALSE, col = "red", type="n") 
ordihull(datos.mds2, datos$Regin, scaling = "symmetric", col = 1:4,
         draw="polygon")
ordispider(datos.mds2, datos$Regin, label=TRUE, kind="se", conf=0.95)



#---------------------
# nMDS con Ordihull
plot(datos.mds2, type = "n",display = c("sites"),
     ylab="Dimensin 2", xlab="Dimensin 1", xlim=c(-1.2,1),
     cex=0.7,cex.lab=1.5)
text(datos.mds2, display="sites", labels = as.character(datos$Finca), cex=0.8)
abline(h=0,lty=2)
abline(v=0,lty=2)
ordihull(datos.mds2, datos$Regin, scaling = "symmetric", col = 1:4,
         draw="polygon", label =TRUE)
ordispider(datos.mds2, datos$Regin, label=TRUE, kind="se", conf=0.95)





#------------------
# nMDS con Ordihull
plot(datos.mds2, type = "n",display = c("sites"),
     ylab="Dimensin 2", xlab="Dimensin 1", xlim=c(-1.2,1),
     cex=0.7,cex.lab=1.5)
text(datos.mds2, display="sites", labels = as.character(datos$Finca), cex=0.8)
abline(h=0,lty=2)
abline(v=0,lty=2)
ordihull(datos.mds2, datos$Regin, scaling = "symmetric", label =TRUE)
ordispider(datos.mds2, datos$Regin, label=TRUE, kind="se", conf=0.95)





# -----------------
# PRUEBA DE HIPTESIS

# Se probar la hiptesis de diferencias de ensamblajes de malezas
# entre diferentes rgiones (grupo: Regin)

datos<-read.csv2("datos2.csv",row.names=1)
str(datos)
library(vegan)

d.jaccard <- vegdist(datos[,4:207],method="jaccard", trace = FALSE)

datos.npMANOVA <- adonis(d.jaccard ~ datos$Regin,perm = 1000)
datos.npMANOVA

# Prueba de homogeneidad de covarianzas
attach(datos)
(datos.homoge <- betadisper(d.jaccard, Regin))
anova(datos.homoge)
permutest(datos.homoge)
# Prueba de Tukey para valorar diferencias de centroides
(tuk.HSD <- TukeyHSD(datos.homoge))
plot(tuk.HSD)

plot(datos.homoge)
plot(datos.homoge, ellipse = TRUE, hull = FALSE)
plot(datos.homoge, ellipse = TRUE, hull = FALSE, conf = 0.90)
plot(datos.homoge, axes = c(3,1), seg.col = "forestgreen", seg.lty = "dashed")
abline(h=0, lty=2)
abline(v=0, lty=2)
boxplot(datos.homoge,notch=TRUE,cex.lab=1.2,
        ylab="Distancias al centroide",col="lightgray") 

# Prueba de multinormalidad (mshapiro.test) no se puede por ser datos binarios
library(mvnormtest)
x <- as.matrix(t(datos))
mshapiro.test(x)





#==============================================================================
# ESCALAMIENTO POR PARCELAS
# Lectura de la base de datos
datos<-read.csv2("datos3.csv",row.names=1)
str(datos)
library(vegan)

#--------------------------------
# OPCIONES DE ESCALAMIENTO CON DISTANCIA JACCARD


# nMDS con la funcin "metaMDS"
datos.mds2 <- metaMDS(datos[,3:206],trace = FALSE,distance = "jaccard")
datos.mds2

#-------------------
# 2)
# Graficas del nMDS con correccin en solapamiento de sp
http://r.789695.n4.nabble.com/label-plotting-on-nmds-diagram-td839832.html

fig=plot(datos.mds2, type = "n",display = c("sites", "species"),
         ylab="Dim 2", xlab="Dim 1", ex=0.6,shrink = FALSE)
abline(h=0,lty=2)
abline(v=0,lty=2)

# Las especies q muestra son promedios ponderados
points(datos.mds2, display = "sites", cex = 0.6, col = "blue")
text(datos.mds2, display="sites", labels = as.character(datos$Lote), 
     cex=0.8, col="blue", lwd=1.5, pos=3, shrink = FALSE)
orditorp(datos.mds2, display = "species", shrink = FALSE, col = "red", type="n") 

ordiellipse(datos.mds2, datos$Regin, scaling = "symmetric", conf=0.95, kind = "sd",
            lwd=2)
ordibar(datos.mds2, datos$Regin, kind="sd", conf=0.95, lwd=1,cex.lab=0.8, 
        label=TRUE)



#--------------------
# Figura tipo Araa en ggplot2 - como Ordispider de vegal
https://stackoverflow.com/questions/47516448/how-to-get-ordispider-like-clusters-in-ggplot-with-nmds

#puntajes del NMDS
scrs <- scores(datos.mds2, display = 'sites')

# Managementcomo una variable al marco de datos de las puntuaciones
scrs <- cbind(as.data.frame(scrs), Regin = datos$Regin)

# centroides de grupo, que son la coordenada media en cada eje, agrupando:
cent <- aggregate(cbind(NMDS1, NMDS2) ~ Regin, data = scrs, FUN = mean)

# Dibujar araa
segs <- merge(scrs, setNames(cent, c('Regin','oNMDS1','oNMDS2')),
              by = 'Regin', sort = FALSE)

# Figura
ggplot(scrs, aes(x = NMDS1, y = NMDS2, colour = Regin)) +
  geom_segment(data = segs, 
               mapping = aes(xend = oNMDS1, yend = oNMDS2)) + # spiders
  geom_point(data = cent, size = 5) +                         # centroids
  geom_point()                      +                         # sample scores
  coord_fixed()   




# -----------------
# PRUEBA DE HIPTESIS

# Se probar la hiptesis de diferencias de ensamblajes de malezas
# entre diferentes rgiones (grupo: Regin)

datos<-read.csv2("datos3.csv",row.names=1)
str(datos)
library(vegan)

d.jaccard <- vegdist(datos[,3:206],method="jaccard", trace = FALSE)

datos.npMANOVA <- adonis(d.jaccard ~ datos$Regin,perm = 1000)
datos.npMANOVA





#-----------------------------
#cargar paquetes
library(devtools)
library(httr)
library(iNEXT)
library(ggplot2)

#cargar matriz de datos
veget= read.csv2(file.choose())
veget
str(veget)

#omtir espacios vacios
veget1=na.omit(veget)
veget1

#calculo de hill
out=iNEXT(veget1[,2:5],q=c(0,1,2),datatype="abundance",endpoint=8000)
out
out$AsyEst
write.csv2(out$AsyEst,"Diver.veget.csv")

# Diversidad beta
# 
library(vegan)
d.bray <- vegdist(veget[,c(2:68)])
d.bray



#grafico
veget_plot=ggiNEXT(out, type=1, facet.var="site", color.var="order")
veget_plot + labs(x = "Nmero de Individuos", y = "Diversidad")
